<?php
use Bitrix\Main\Localization\Loc;
use Bitrix\Main\Config\Option;
use Bitrix\Sale\PaySystem;
use Bitrix\Main\Loader;

Loc::loadMessages(__FILE__);
require dirname(dirname(__FILE__)) . '/config.php';

$statuses = CSaleStatus::GetList(['SORT' => 'ASC'], ['LID' => LANGUAGE_ID], false, false, ['ID', 'NAME']);
$resultStatuses = [];
while ($status = $statuses->Fetch())
	$resultStatuses[$status['ID']] = '[' . $status['ID'] . '] ' . $status['NAME'];


$fes = array(
	"RBS_FES_CASHBOX_ID" => array(
		"NAME" => Loc::getMessage("RBS_PAYMENT_FESCASHBOX_ID_DESCRIPTION_NAME"),
		"DESCRIPTION" => Loc::getMessage("RBS_PAYMENT_FESCASHBOX_ID_DESCRIPTION_DESCR"),
		'SORT' => 770,
		'GROUP' => Loc::getMessage("RBS_GROUP_GROUP_OTHER"),
	),
);


$close_ofd_reciept = array(
	"RBS_PAYMENT_CLOSE_OFD_RECEIPT_STATUS" => array(
		"NAME" => GetMessage("RBS_PAYMENT_CLOSE_OFD_RECEIPT_STATUS_NAME"),
		"DESCRIPTION" => GetMessage("RBS_PAYMENT_CLOSE_OFD_RECEIPT_STATUS_DESCR"),
		"SORT" => 440,
		"INPUT" => array(
			'TYPE'      => 'ENUM',
			'OPTIONS'   => $resultStatuses,
		),
		'DEFAULT' => array(
			'PROVIDER_KEY' => 'INPUT',
			'PROVIDER_VALUE'  => ""
		),
		'GROUP' => GetMessage("RBS_GROUP_OFD"),
	),
);

$fiscal = array(
	"FFD_VERSION" => array(
		"NAME" => Loc::getMessage("RBS_FFD_VERSION_NAME"),
		"DESCRIPTION" => Loc::getMessage("RBS_FFD_VERSION_DESCR"),
		'SORT' => 400,
		'GROUP' => Loc::getMessage("RBS_GROUP_FFD"),
		'TYPE' => 'SELECT',
		'INPUT' => array(
			'TYPE' => 'ENUM',
			'OPTIONS' => array(
				'1.05' => '1.05',
				'1.2' => '1.2',
			)
		),
		'DEFAULT' => array(
			"PROVIDER_VALUE" => "1.05",
        	"PROVIDER_KEY" => "INPUT"
		)
	),
	"FFD_PAYMENT_METHOD" => array(
		"NAME" => Loc::getMessage("RBS_FFD_PAYMENT_METHOD_NAME"),
		"DESCRIPTION" => Loc::getMessage("RBS_FFD_PAYMENT_METHOD_DESCR"),
		'SORT' => 410,
		'GROUP' => Loc::getMessage("RBS_GROUP_FFD"),
		'TYPE' => 'SELECT',
		'INPUT' => array(
			'TYPE' => 'ENUM',
			'OPTIONS' => array(
                "1" => GetMessage('RBS_FFD_PAYMENT_METHOD_VALUE_1'),
                "2" => GetMessage('RBS_FFD_PAYMENT_METHOD_VALUE_2'),
                "3" => GetMessage('RBS_FFD_PAYMENT_METHOD_VALUE_3'),
                "4" => GetMessage('RBS_FFD_PAYMENT_METHOD_VALUE_4'),
                "5" => GetMessage('RBS_FFD_PAYMENT_METHOD_VALUE_5'),
                "6" => GetMessage('RBS_FFD_PAYMENT_METHOD_VALUE_6'),
                "7" => GetMessage('RBS_FFD_PAYMENT_METHOD_VALUE_7'),
			)
		),
		'DEFAULT' => array(
			"PROVIDER_VALUE" => "1",
        	"PROVIDER_KEY" => "INPUT"
		)
	),
	"FFD_PAYMENT_OBJECT" => array(
		"NAME" => Loc::getMessage("RBS_FFD_PAYMENT_OBJECT_NAME"),
		"DESCRIPTION" => Loc::getMessage("RBS_FFD_PAYMENT_OBJECT_DESCR"),
		'SORT' => 420,
		'GROUP' => Loc::getMessage("RBS_GROUP_FFD"),
		'TYPE' => 'SELECT',
		'INPUT' => array(
			'TYPE' => 'ENUM',
			'OPTIONS' => array(
                "1"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_1'),
                "2"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_2'),
                "3"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_3'),
                "4"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_4'),
                "5"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_5'),
                "6"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_6'),
                "7"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_7'),
                "8"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_8'),
                "9"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_9'),
                "10" =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_10'),
                "11" =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_11'),
                "12" =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_12'),
                "13" =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_13'),
			)
		),
		'DEFAULT' => array(
			"PROVIDER_VALUE" => "1",
        	"PROVIDER_KEY" => "INPUT"
		)
	),
	"FFD_PAYMENT_OBJECT_DELIVER" => array(
		"NAME" => Loc::getMessage("RBS_FFD_PAYMENT_OBJECT_DELIVERY_NAME"),
		"DESCRIPTION" => Loc::getMessage("RBS_FFD_PAYMENT_OBJECT_DESCR"),
		'SORT' => 421,
		'GROUP' => Loc::getMessage("RBS_GROUP_FFD"),
		'TYPE' => 'SELECT',
		'INPUT' => array(
			'TYPE' => 'ENUM',
			'OPTIONS' => array(
                "1"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_1'),
                "2"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_2'),
                "3"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_3'),
                "4"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_4'),
                "5"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_5'),
                "6"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_6'),
                "7"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_7'),
                "8"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_8'),
                "9"  =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_9'),
                "10" =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_10'),
                "11" =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_11'),
                "12" =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_12'),
                "13" =>  GetMessage('RBS_FFD_PAYMENT_OBJECT_VALUE_13'),
			)
		),
		'DEFAULT' => array(
			"PROVIDER_VALUE" => "4",
        	"PROVIDER_KEY" => "INPUT"
		)
	),
	"OFD_RECIEPT" => array(
		"NAME" => Loc::getMessage("RBS_OFD_RECIEPT_NAME"),
		"DESCRIPTION" => Loc::getMessage("RBS_OFD_RECIEPT_DESCR"),
		'SORT' => 520,
		'GROUP' => Loc::getMessage("RBS_GROUP_OFD"),
		"INPUT" => array(
			'TYPE' => 'Y/N'
		),
		'DEFAULT' => array(
			"PROVIDER_VALUE" => "N",
        	"PROVIDER_KEY" => "INPUT"
		)
	),
	"OFD_TAX_SYSTEM" => array(
		"NAME" => Loc::getMessage("RBS_OFD_TAX_SYSTEM_NAME"),
		"DESCRIPTION" => Loc::getMessage("RBS_OFD_TAX_SYSTEM_DESCR"),
		'SORT' => 530,
		'GROUP' => Loc::getMessage("RBS_GROUP_OFD"),
		'TYPE' => 'SELECT',
		'INPUT' => array(
			'TYPE' => 'ENUM',
			'OPTIONS' => array(
                "0"  =>  GetMessage('RBS_OFD_RECIEPT_VALUE_0'),
                "1"  =>  GetMessage('RBS_OFD_RECIEPT_VALUE_1'),
                "2"  =>  GetMessage('RBS_OFD_RECIEPT_VALUE_2'),
                "3"  =>  GetMessage('RBS_OFD_RECIEPT_VALUE_3'),
                "4"  =>  GetMessage('RBS_OFD_RECIEPT_VALUE_4'),
                "5"  =>  GetMessage('RBS_OFD_RECIEPT_VALUE_5'),
			)
		),
		'DEFAULT' => array(
			"PROVIDER_VALUE" => "1",
        	"PROVIDER_KEY" => "INPUT"
		)
	),
);
$cacert = array(
	"API_ENABLE_CACERT" => array(
		"NAME" => Loc::getMessage("RBS_API_CERT_NAME"),
		"DESCRIPTION" => Loc::getMessage("RBS_API_CERT_DESCR"),
		'SORT' => 135,
		'GROUP' => Loc::getMessage("RBS_GROUP_GATE"),
		"INPUT" => array(
			'TYPE' => 'Y/N'
		),
		'DEFAULT' => array(
			"PROVIDER_VALUE" => "N",
        	"PROVIDER_KEY" => "INPUT"
		)
	)
);
$data = array(
	'NAME' => Loc::getMessage("RBS_MODULE_TITLE") . ' ' . $RBS_CONFIG['BANK_NAME'] ,
	'SORT' => 100,
	'CODES' => array(
		"API_LOGIN" => array(
			"NAME" => Loc::getMessage("RBS_API_LOGIN_NAME"),
			"DESCRIPTION" => Loc::getMessage("RBS_API_LOGIN_DESCR"),
			'SORT' => 100,
			'GROUP' => Loc::getMessage("RBS_GROUP_GATE"),
		),
		"API_PASSWORD" => array(
			"NAME" => Loc::getMessage("RBS_API_PASSWORD_NAME"),
			"DESCRIPTION" => Loc::getMessage("RBS_API_PASSWORD_DESCR"),
			'SORT' => 120,
			'GROUP' => Loc::getMessage("RBS_GROUP_GATE"),
		),
		"API_TEST_MODE" => array(
			"NAME" => Loc::getMessage("RBS_API_TEST_MODE_NAME"),
			"DESCRIPTION" => Loc::getMessage("RBS_API_TEST_MODE_DESCR"),
			'SORT' => 130,
			'GROUP' => Loc::getMessage("RBS_GROUP_GATE"),
			"INPUT" => array(
				'TYPE' => 'Y/N'
			),
			'DEFAULT' => array(
				"PROVIDER_VALUE" => "N",
            	"PROVIDER_KEY" => "INPUT"
			)
		),
		"HANDLER_AUTO_REDIRECT" => array(
			"NAME" => Loc::getMessage("RBS_HANDLER_AUTO_REDIRECT_NAME"),
			"DESCRIPTION" => Loc::getMessage("RBS_HANDLER_AUTO_REDIRECT_DESCR"),
			'SORT' => 200,
			'GROUP' => Loc::getMessage("RBS_GROUP_HANDLER"),
			"INPUT" => array(
				'TYPE' => 'Y/N'
			),
			'DEFAULT' => array(
				"PROVIDER_VALUE" => "N",
            	"PROVIDER_KEY" => "INPUT"
			)
		),
		"HANDLER_LOGGING" => array(
			"NAME" => Loc::getMessage("RBS_HANDLER_LOGGING_NAME"),
			"DESCRIPTION" => Loc::getMessage("RBS_HANDLER_LOGGING_DESCR"),
			'SORT' => 210,
			'GROUP' => Loc::getMessage("RBS_GROUP_HANDLER"),
			"INPUT" => array(
				'TYPE' => 'Y/N'
			),
			'DEFAULT' => array(
				"PROVIDER_VALUE" => "Y",
            	"PROVIDER_KEY" => "INPUT"
			)
		),
		"HANDLER_TWO_STAGE" => array(
			"NAME" => Loc::getMessage("RBS_HANDLER_TWO_STAGE_NAME"),
			"DESCRIPTION" => Loc::getMessage("RBS_HANDLER_TWO_STAGE_DESCR"),
			'SORT' => 220,
			'GROUP' => Loc::getMessage("RBS_GROUP_HANDLER"),
			"INPUT" => array(
				'TYPE' => 'Y/N'
			),
			'DEFAULT' => array(
				"PROVIDER_VALUE" => "N",
            	"PROVIDER_KEY" => "INPUT"
			)
		),
		"HANDLER_SHIPMENT" => array(
			"NAME" => Loc::getMessage("RBS_HANDLER_SHIPMENT_NAME"),
			"DESCRIPTION" => Loc::getMessage("RBS_HANDLER_SHIPMENT_DESCR"),
			'SORT' => 320,
			'GROUP' => Loc::getMessage("RBS_GROUP_HANDLER"),
			"INPUT" => array(
				'TYPE' => 'Y/N'
			),
			'DEFAULT' => array(
				"PROVIDER_VALUE" => "N",
            	"PROVIDER_KEY" => "INPUT"
			)
		),
		"RETURN_URL" => array(
			"NAME" => Loc::getMessage("RBS_PAYMENT_RETURN_URL_NAME"),
			"DESCRIPTION" => Loc::getMessage("RBS_PAYMENT_RETURN_URL_DESCR"),
			'SORT' => 330,
			'GROUP' => Loc::getMessage("RBS_GROUP_GATE"),
		),
		"FAIL_URL" => array(
			"NAME" => Loc::getMessage("RBS_PAYMENT_FAIL_URL_NAME"),
			"DESCRIPTION" => Loc::getMessage("RBS_PAYMENT_FAIL_URL_DESCR"),
			'SORT' => 340,
			'GROUP' => Loc::getMessage("RBS_GROUP_GATE"),
		),		



		"RBS_ORDER_NUMBER" => array(
			"NAME" => Loc::getMessage("RBS_ORDER_NUMBER_NAME"),
			"DESCRIPTION" => Loc::getMessage("RBS_ORDER_NUMBER_DESCR"),
			'SORT' => 650,
			'GROUP' => Loc::getMessage("RBS_GROUP_ORDER"),
			'DEFAULT' => array(
				'PROVIDER_KEY' => 'ORDER',
				'PROVIDER_VALUE' => 'ACCOUNT_NUMBER'
			)
		),
		"RBS_ORDER_AMOUNT" => array(
			"NAME" => Loc::getMessage("RBS_ORDER_AMOUNT_NAME"),
			"DESCRIPTION" => Loc::getMessage("RBS_ORDER_AMOUNT_DESCR"),
			'SORT' => 660,
			'GROUP' => Loc::getMessage("RBS_GROUP_ORDER"),
			'DEFAULT' => array(
				'PROVIDER_KEY' => 'PAYMENT',
				'PROVIDER_VALUE' => 'SUM'
			)
		),
		"RBS_ORDER_DESCRIPTION" => array(
			"NAME" => Loc::getMessage("RBS_ORDER_DESCRIPTION_NAME"),
			"DESCRIPTION" => Loc::getMessage("RBS_ORDER_DESCRIPTION_DESCR"),
			'SORT' => 670,
			'GROUP' => Loc::getMessage("RBS_GROUP_ORDER"),
			'DEFAULT' => array(
				'PROVIDER_KEY' => 'ORDER',
				'PROVIDER_VALUE' => 'USER_DESCRIPTION'
			)
		),

	)
);
if($RBS_CONFIG['RBS_ENABLE_FISCALE_OPTIONS']) {
	$data['CODES'] = array_merge($data['CODES'], $fiscal);
	$data['CODES'] = array_merge($data['CODES'], $close_ofd_reciept);
}
if(file_exists(dirname(dirname(__FILE__)) . "/cacert.cer")) {
	$data['CODES'] = array_merge($data['CODES'], $cacert);
}
if($RBS_CONFIG['RBS_ENABLE_FES_CODES']) { 
	$data['CODES'] = array_merge($data['CODES'], $fes);
}
